import {createRouter, createWebHistory} from 'vue-router';

const router = createRouter({
    history: createWebHistory(),
    routes: [
        {
            path: '/',
            component: () => import('./pages/Home.vue')
        },
        {
            path: '/blog/:categorie',
            component: () => import('./pages/Blog.vue'),
            props: true
        },
        {
            path: '/login',
            component: () => import('./pages/Login.vue')
        },
        {
            path: '/article/:value',
            component: () => import('./pages/Article.vue'),
            props : true
        },
        {
            path: '/home',
            component: () => import('./pages/Home.vue')
        },
        {
            path: '/admin',
            component: () => import('./pages/HomeAdmin.vue'),
        },
        {
            path: '/editart/:article',
            component: () => import('./pages/EditArticle.vue'),
            props: true
        },
        {
            path: '/newart/:categorie',
            component: () => import('./pages/EditArticle.vue'),
            props: true
        },
        {
            path: '/editcat/:categorie',
            component: () => import('./pages/EditCategorie.vue'),
            props: true
        },
        {
            path: '/editcarte/:trajet',
            component: () => import('./pages/EditCarte.vue'),
            props:true

        }

    ],
})
router.beforeEach((to, from, next) => {
    if (to.path === '/admin' && !isAuthenticated()) {
        return next({path: '/login'})
    }
    return next()
})

function isAuthenticated() {
    return Boolean(localStorage.getItem('ROADTRIP_APP_USER_TOKEN'))
}

export default router;