import axios from "axios";

export const request = async (method, url, data) => {
    const token = localStorage.getItem('ROADTRIP_APP_USER_TOKEN')
    if (token !== undefined || token !== "") {
        const headers = {
            headers: {
                Authorization: 'Bearer ' + token
            }
        }
        let response = null;
        try {
            switch (method) {
                case 'get':
                    response = await axios.get(url, headers)
                    break;
                case 'post':
                    response = await axios.post(url, data, headers)
                    break;
                case 'put':
                    response = await axios.put(url, data, headers)
                    break;
                case 'delete':
                    response = await axios.delete(url, headers)
                    break;
                default:
                    break;
            }
        } catch (e) {
            if (e.response) {
                response = e.response
            }
        }
        return response
    }
    return false
}

export const upload_file = async (url, file) => {
    const token = localStorage.getItem('ROADTRIP_APP_USER_TOKEN')
    if (token !== undefined || token !== "") {
        const headers = {
            headers: {
                Authorization: 'Bearer ' + token,
                "Content-Type" : 'multipart/form-data'
            }
        }
        let formData = new FormData();
        formData.append("file", file);
        let response = null;
        response = await axios.post(url, formData, headers)
        return response
    }
    return false
}

export const requestosrm = async(fromlat,fromlng,tolat,tolng) => {
    const headers = {
        "Content-Type" : "text/plain"    
    }
    const url = "http://router.project-osrm.org/route/v1/driving/"+fromlng+","+fromlat+";"+tolng+","+tolat+"?steps=true&geometries=geojson"
    var response = await axios.get(url, headers)

    return response
}


export function getmenus(role) {
    if (role == "admin") {
        return { "Accueil" : "/",
                 "Editer" : "/editoutils",
                 "Reservations" : "/reservations"}
    } else {
        return { "Accueil" : "/",
                 "Profil" : "/profil"
                 }
    }
}

import moment from "moment"
import 'moment/dist/locale/fr'

export function formatdate(d) {
    return moment(d).locale('fr').format("D MMMM YYYY HH:mm")
}