<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Markup extends Model
{
    use HasFactory;

    protected $fillable = [
        'carte_id',
        'latlong',
        'contenu',
        'max_width',
        'min_width'
    ];

    public $timestamps = false;

    protected function latlong(): Attribute
    {
        return Attribute::make(
            get: fn ($value) => json_decode($value, true),
            set: fn ($value) => json_encode($value),
        );
    }

}