<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Article extends Model
{
    use HasFactory;

    protected $fillable = [
        'titre',
        'contenu',
        'description',
        'file_id',
        'categorie_id',
        'carte_id',
        'publie'
    ];

    public function file() : HasOne{
        return $this->hasOne(File::class);
    }

    public function categorie() : HasOne {
        return $this->hasOne(Categorie::class);
    }


}