<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\File;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;


class FileUpload extends Controller
{
  public function createForm(){
    //return view('file-upload');
  }
  public function fileUpload(Request $req){
        $req->validate([
        'file' => 'required|mimes:csv,txt,xlx,xls,pdf,jpg,png,webp|max:2048'
        ]);
        $fileModel = new File;
        if($req->file()) {
            $fileName = time().'_'.$req->file->getClientOriginalName();
            $filePath = $req->file('file')->storeAs('uploads', $fileName, 'public');
            $fileModel->name = $fileName;
            $fileModel->file_path = '/storage/' . $filePath;
            $fileModel->save();

            //retaille l'image
            $thumbnailpath = public_path('storage/uploads/thumbnail/'.$fileName);
            $imagepath = public_path('storage/uploads/'.$fileName);
            $thumbrelativepath = '/storage/uploads/'.$fileName;
            $manager = new ImageManager(new Driver());
            $image = $manager->read($imagepath);
            $image->scale(width: 100);
            $image->save($thumbnailpath);
            


           // return response()->json(['status' => true, 'filename' => $fileModel->file_path, 'fileid' => $fileModel->id]);
           //return response()->json(['urls' => [ "default" => $fileModel->file_path,
           //                                     "100" => $thumbrelativepath ],
           //                         'id' => $fileModel->id]);
           return response()->json(['urls' => [ "default" => $fileModel->file_path ],
                                    'id' => $fileModel->id]);
        }
   }
}