<?php

namespace App\Http\Controllers;

use App\Models\Carte;
use App\Models\Trajet;
use App\Models\Markup;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class CartesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(): \Illuminate\Http\JsonResponse
    {
 
        $data = Carte::query()->get();
        return response()->json(['status' => true, 'data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request): \Illuminate\Http\JsonResponse
    {
        $data = Carte::where('nom', $request->nom);
        if ($data->first()) {
            return response()->json(['status' => false, 'message' => 'Already exist']);
        }
        $req = $request->all();        
        $data = Carte::create($req);
        return response()->json(['status' => true, 'data' => $data], 201);
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id): \Illuminate\Http\JsonResponse
    {
        $response = Carte::findOrFail($id);

        return response()->json($response->first(), 200);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Request $request, $id): \Illuminate\Http\JsonResponse
    {
        $validateUser = Validator::make($request->all(),
            [
                'nom' => 'required'
            ]);

        if ($validateUser->fails()) {
            return response()->json([
                'status' => false,
                'message' => 'validation error',
                'errors' => $validateUser->errors()
            ], 401);
        }

        $data = Carte::find($id);
        $data->nom = $request->nom;
        $data->update();
        return response()->json(['status' => true, 'data' => $data], 202);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     * @throws \Throwable
     */
    public function destroy(int $id): \Illuminate\Http\JsonResponse
    {
        throw_if(!$id, 'Carte Id is missing');
        Carte::findOrFail($id)->delete();
        Trajet::where("carte_id","=",$id)->delete();
        Markup::where("carte_id","=",$id)->delete();
        return response()->json(['status' => true, 'message' => 'Carte deleted']);
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function trajet($id): \Illuminate\Http\JsonResponse
    {
        $iti = Carte::find($id);
        $trajet = Trajet::where("carte_id","=",$id)->get();
        $markup = Markup::where("carte_id","=",$id)->get();

        $data = ["nom" => $iti->nom, 
                "id" => $iti->id, 
                "view" => $iti->view , 
                "zoom" => $iti->zoom, 
                "trajet" => $trajet,
                "markup" => $markup];

        return response()->json(['status' => true, 'data' => $data], 200);
    }

    /**
     * 
     */
    public function createtrajet(Request $request) : \Illuminate\Http\JsonResponse
    {
        $validateUser = Validator::make($request->all(),
        [
            'trajet' => 'required',
            'nom' => 'required',
            'view' => 'required',
            'zoom' => 'required'
        ]);

        if ($validateUser->fails()) {
            return response()->json([
                'status' => false,
                'message' => 'Un des champs obligatoire est manquant',
                'errors' => $validateUser->errors()
            ], 400);
        }

        $data = Carte::where('nom', $request->nom);
        if ($data->first()) {
            return response()->json(['status' => false, 'message' => 'Already exist']);
        }
        $req = $request->all();        
        $iti = Carte::create($req);

        foreach ($request->trajet as $req) {
            $trajet = Trajet::create(["carte_id" => $iti->id,
                                        "label_de" => $req["label_de"],
                                        "label_vers" => $req["label_vers"],
                                        "latlong_de" => $req["latlong_de"],
                                        "latlong_vers" => $req["latlong_vers"],
                                        "polylines" => $req["polylines"],
                                        "distance" => $req["distance"],
                                        "type" => $req["type"]
                                    ]);
        }

        $trajet = Trajet::where("carte_id","=",$iti->id)->get();

        foreach ($request->markup as $req) {
            $markup = Markup::create(["carte_id" => $iti->id,
                                        "latlong" => $req["latlong"],
                                        "contenu" => $req["contenu"],
                                        "max_width" => $req["max_width"],
                                        "min_width" => $req["min_width"]
                                    ]);
        }

        $markup = Markup::where("carte_id","=",$iti->id)->get();

        $data = ["nom" => $iti->nom, "id" => $iti->id, "trajet" => $trajet, "markup" => $markup];

        return response()->json(['status' => true, 'data' => $data], 201);
    }


    /**
     * 
     */
    public function updatetrajet(Request $request, $id) : \Illuminate\Http\JsonResponse
    {
        $validateUser = Validator::make($request->all(),
        [
            'trajet' => 'required',
            'nom' => 'required',
            'view' => 'required',
            'zoom' => 'required'
        ]);

        if ($validateUser->fails()) {
            return response()->json([
                'status' => false,
                'message' => 'validation error',
                'errors' => $validateUser->errors()
            ], 400);
        }

        $iti = Carte::find($id);
        $iti->nom = $request->nom;
        $iti->view = $request->view;
        $iti->zoom = $request->zoom;

        $iti->update();

        //$trajet = Trajet::where("carte_id","=",$id)->get();

        foreach ($request->trajet as $req) {
            if ($req["id"] <= 0) {
                $trajet = Trajet::create(["carte_id" => $req["carte_id"],
                                          "label_de" => $req["label_de"],
                                          "label_vers" => $req["label_vers"],
                                          "latlong_de" => $req["latlong_de"],
                                          "latlong_vers" => $req["latlong_vers"],
                                          "polylines" => $req["polylines"],
                                          "distance" => $req["distance"],
                                          "type" => $req["type"]
                                        ]);

            } else {            
                $trajet = Trajet::find($req["id"]);

                $trajet->latlong_de = $req["latlong_de"];
                $trajet->latlong_vers = $req["latlong_vers"];
                $trajet->label_de = $req["label_de"];
                $trajet->label_vers = $req["label_vers"];
                $trajet->polylines = $req["polylines"];
                $trajet->distance = $req["distance"];
                $trajet->update();
            }
        }

        foreach ($request->markup as $req) {
            if ($req["id"] <= 0) {
                $trajet = Markup::create(["carte_id" => $req["carte_id"],
                                          "latlong" => $req["latlong"],
                                          "contenu" => $req["contenu"],
                                          "max_width" => $req["max_width"],
                                          "min_width" => $req["min_width"]
                                        ]);

            } else {            
                $trajet = Markup::find($req["id"]);

                $trajet->latlong = $req["latlong"];
                $trajet->contenu = $req["contenu"];
                $trajet->max_width = $req["max_width"];
                $trajet->min_width = $req["min_width"];
                $trajet->update();
            }
        }



        $trajet = Trajet::where("carte_id","=",$id)->get();
        $markup = Markup::where("carte_id","=",$id)->get();
        $data = ["nom" => $iti->nom, "id" => $iti->id, "trajet" => $trajet, "markup" => $markup];
        return response()->json(['status' => true, 'data' => $data], 202);

    }

}
