<?php

namespace App\Http\Controllers;

use App\Models\Article;
use App\Models\Carte;
use App\Models\User;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


class ArticlesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request): \Illuminate\Http\JsonResponse
    {
        //\DB::enableQueryLog();

        //$data = Article::query()->get();        
        $data = Article::leftjoin("files","articles.file_id","=","files.id")
                        ->leftjoin("cartes","articles.carte_id","=","cartes.id")
                        ->select("articles.*","files.file_path","cartes.id as carte_id")
                        ->where("publie","=",true)
                        ->orderBy("created_at",'desc')
                        ->get();                        
      
        //\Log::info(\DB::getQueryLog());

        return response()->json(['status' => true, 'data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request): \Illuminate\Http\JsonResponse
    {
        $data = Article::where('nom', $request->nom);
        if ($data->first()) {
            return response()->json(['status' => false, 'message' => 'Already exist']);
        }
        $req = $request->all();        
        $data = Article::create($req);
        return response()->json(['status' => true, 'data' => $data], 201);
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id): \Illuminate\Http\JsonResponse
    {
        $user = auth()->user();

        //$response = Article::findOrFail($id);
        $query = Article::leftjoin("files","articles.file_id","=","files.id")
                        ->select("articles.*","files.file_path")
                        ->where("articles.id",'=',$id);
        if (!$user) {
            $query->where("publie","=",true);
        }

        $result = $query->get();  


        $article = $result->first();
        if ($article) {
            $carte = Carte::find($article->carte_id);
            $article["carte"] = $carte;
            return response()->json($article, 200);
        } else {
            return response()->json("L'article n'existe pas", 404);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function showbycategorie($id): \Illuminate\Http\JsonResponse
    {
        //$response = Article::findOrFail($id);
        $response = Article::leftjoin("files","articles.file_id","=","files.id")
                        ->leftjoin("categories","articles.categorie_id", "=","categories.id")
                        ->select("articles.*","files.file_path","categories.nom as categoriename")                        
                        ->where("categorie_id",'=',$id)
                        ->where("publie","=",true)
                        ->orderBy("created_at",'desc')
                        ->get();

        return response()->json(['status' => true, 'data' => $response], 201);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Request $request, $id): \Illuminate\Http\JsonResponse
    {
        $validateUser = Validator::make($request->all(),
            [
                'description' => 'required',
                'titre' => 'required',
                'contenu' => 'required'
            ]);

        if ($validateUser->fails()) {
            return response()->json([
                'status' => false,
                'message' => 'validation error',
                'errors' => $validateUser->errors()
            ], 400);
        }

        $data = Article::find($id);
        $data->titre = $request->titre;
        $data->description = $request->description;
        $data->contenu = $request->contenu;
        $data->file_id = $request->file_id;
        $data->carte_id = $request->carte_id;
        $data->publie = $request->publie;
        $data->update();
        return response()->json(['status' => true, 'data' => $data], 202);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     * @throws \Throwable
     */
    public function destroy(int $id): \Illuminate\Http\JsonResponse
    {
        throw_if(!$id, 'Article Id is missing');
        Article::findOrFail($id)->delete();
        return response()->json(['status' => true, 'message' => 'article deleted']);
    }
}
