<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\Carte;

class TrajetsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

       $iti = Carte::create([
            'nom' => 'Mon itinéraire',
            'view' => json_encode([56.559482483762245,11.09619140625]),
            'zoom' => 8
       ]);

       $str = file_get_contents('resources/js/components/maps/malmo_jonkoping.json');
       $json = json_decode($str);
       $polyline = [];
       $distance = 0;
       foreach ($json->routes as $routes) {            
            foreach($routes->legs as $leg) {
                foreach ($leg->steps as $step) {
                    $polyline = array_merge($polyline,$step->geometry->coordinates);
                    $distance += $step->distance;
                }                
            }
        }



        DB::table('trajets')->insert([
             'label_de' => 'Départ',
             'label_vers' => 'Arrivée',
             'carte_id' => $iti->id,
             'latlong_de' => json_encode([55.5666985605045,12.917175292968752]),
             'latlong_vers' => json_encode([57.75840310072884,14.161376953125]),
             'polylines' => json_encode($polyline),
             'distance' => $distance,
             'type' => 'geojson'
        ]);
    }
}
