<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Categorie;
use App\Models\Article;
use Illuminate\Support\Facades\Validator;

class CategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(): \Illuminate\Http\JsonResponse
    {
 
        //$data = categories::query()->get();
        $data = Categorie::leftjoin("files","categories.file_id","=","files.id")
                        ->select("categories.*","files.file_path")
                        ->orderBy("categories.id")
                        ->get();
        return response()->json(['status' => true, 'data' => $data]);
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function tree(): \Illuminate\Http\JsonResponse
    {
        $data = [];
        $categories = Categorie::get();

        foreach ($categories as $cat ){
            $articles = Article::select("titre","id")
                                ->where("categorie_id","=",$cat->id)
                                ->get();
            $c = ["id" => $cat->id, "nom" => $cat->nom, "articles" => $articles];            
            array_push($data,$c);
        }

        return response()->json(['status' => true, 'data' => $data]);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request): \Illuminate\Http\JsonResponse
    {
        $data = Categorie::where('nom', $request->nom);
        if ($data->first()) {
            return response()->json(['status' => false, 'message' => 'Already exist']);
        }
        $req = $request->all();        
        $data = Categorie::create($req);
        return response()->json(['status' => true, 'data' => $data], 201);
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id): \Illuminate\Http\JsonResponse
    {
        $response = Categorie::findOrFail($id);
        
        $response = Categorie::leftjoin("files","categories.file_id","=","files.id")
                        ->select("categories.*","files.file_path")
                        ->where("categories.id",'=',$id)
                        ->orderBy("created_at",'desc')
                        ->get();

        return response()->json($response->first(), 200);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Request $request, $id): \Illuminate\Http\JsonResponse
    {
        $validateUser = Validator::make($request->all(),
            [
                'description' => 'required',
                'nom' => 'required',
            ]);

        if ($validateUser->fails()) {
            return response()->json([
                'status' => false,
                'message' => 'validation error',
                'errors' => $validateUser->errors()
            ], 401);
        }

        $data = Categorie::find($id);
        $data->nom = $request->nom;
        $data->description = $request->description;
        $data->file_id = $request->file_id;
        $data->update();
        return response()->json(['status' => true, 'data' => $data], 202);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     * @throws \Throwable
     */
    public function destroy(int $id): \Illuminate\Http\JsonResponse
    {
        throw_if(!$id, 'Categorie Id is missing');
        Categorie::findOrFail($id)->delete();
        return response()->json(['status' => true, 'message' => 'Categorie deleted']);
    }
}
