<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ArticlesController;
use App\Http\Controllers\FileUpload;
use App\Http\Controllers\AccueilController;
use App\Http\Controllers\CategoriesController;
use App\Http\Controllers\CartesController;
use App\Http\Controllers\CommentsController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('/auth/register', [AuthController::class, 'register']);
Route::post('/auth/login', [AuthController::class, 'login']);

Route::get('article', [ArticlesController::class,'index']);
Route::get('article/{article}', [ArticlesController::class,'show']);
Route::get('articlecat/{categorie}', [ArticlesController::class,'showbycategorie']);
Route::post('article', [ArticlesController::class,'store'])->middleware('auth:sanctum','role:admin');
Route::put('article/{id}', [ArticlesController::class,'update'])->middleware('auth:sanctum','role:admin');
Route::delete('article/{id}', [ArticlesController::class,'destroy'])->middleware('auth:sanctum','role:admin');

Route::get('home', [AccueilController::class,'index']);

Route::get('categorie', [CategoriesController::class,'index']);
Route::get('categorie/{categorie}', [CategoriesController::class,'show']);
Route::get('categorietree', [CategoriesController::class,'tree']);
Route::post('categorie', [CategoriesController::class,'store'])->middleware('auth:sanctum','role:admin');
Route::put('categorie/{id}', [CategoriesController::class,'update'])->middleware('auth:sanctum','role:admin');
Route::delete('categorie/{id}', [CategoriesController::class,'destroy'])->middleware('auth:sanctum','role:admin');

Route::get('comment', [CommentsController::class,'index']);
Route::get('comment/{comment}', [CommentsController::class,'show']);
Route::post('comment', [CommentsController::class,'store']);
Route::put('comment/{id}', [CommentsController::class,'update'])->middleware('auth:sanctum','role:admin');
Route::delete('comment/{id}', [CommentsController::class,'destroy'])->middleware('auth:sanctum','role:admin');

Route::post('upload-file', [FileUpload::class, 'fileUpload'])->name('fileUpload')->middleware('auth:sanctum');

Route::apiResource('carte', CartesController::class)->middleware('auth:sanctum');

//Route::apiResource('coord', CoordsController::class)->middleware('auth:sanctum');
Route::get('/trajet/{id}', [CartesController::class,'trajet']);
Route::put('/trajet/{id}', [CartesController::class,'updatetrajet'])->middleware('auth:sanctum');
Route::post('/trajet', [CartesController::class,'createtrajet'])->middleware('auth:sanctum');



Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::put('/users/{user}',[UsersController::class,'update'])->middleware('auth:sanctum');

Route::get('/login', function() {
    return view('welcome');
});

