<?php

namespace App\Http\Controllers;

use App\Models\Article;
use App\Models\Comment;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class CommentsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(): \Illuminate\Http\JsonResponse
    {
 
        //$data = Article::query()->get();
        $data = Comment::orderby("created_at")->get();
        return response()->json(['status' => true, 'data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request): \Illuminate\Http\JsonResponse
    {
        $validateUser = Validator::make($request->all(),
            [
                'article_id' => 'required',
                'contenu' => 'required',
                'auteur' => 'required'
            ]);

        if ($validateUser->fails()) {
            return response()->json([
                'status' => false,
                'message' => 'validation error',
                'errors' => $validateUser->errors()
            ], 401);
        }

        $data = Article::find($request->article_id);
        if (!$data->first()) {
            return response()->json(['status' => false, 'message' => "L'article n'existe pas"]);
        }
        $req = $request->all();        
        $data = Comment::create($req);
        return response()->json(['status' => true, 'data' => $data], 201);
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id): \Illuminate\Http\JsonResponse
    {
        $data = Comment::where("article_id","=",$id)->orderby("created_at")->get();

        $ret = [];
        foreach ($data as $d) {
            if ($d["reply_id"]===null) {
                array_push($ret,$d->toArray());
            } else {
                foreach($ret as $k=>$s) {
                    if ($s["id"]==$d["reply_id"]) {
                        if (!array_key_exists("replies",$ret[$k])) {
                            $ret[$k]["replies"] = [];
                        }
                        array_push($ret[$k]["replies"],$d->toArray());
                    }
                }
            }
        }

        return response()->json(['status' => true, 'data' => $ret], 200);

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Request $request, $id): \Illuminate\Http\JsonResponse
    {
        $validateUser = Validator::make($request->all(),
            [
                'article_id' => 'required',
                'contenu' => 'required',
                'auteur' => 'required'
            ]);

        if ($validateUser->fails()) {
            return response()->json([
                'status' => false,
                'message' => 'validation error',
                'errors' => $validateUser->errors()
            ], 401);
        }

        $data = Comment::find($id);
        $data->contenu = $request->contenu;
        $data->auteur = $request->auteur;
        $data->update();
        return response()->json(['status' => true, 'data' => $data], 202);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     * @throws \Throwable
     */
    public function destroy(int $id): \Illuminate\Http\JsonResponse
    {
        throw_if(!$id, 'Comment Id is missing');
        Comment::findOrFail($id)->delete();
        return response()->json(['status' => true, 'message' => 'commentaire supprimé']);
    }
}
